package easik.sketch.attribute;

import java.util.ArrayList;
import java.util.Comparator;

import easik.EasikConstants;
/**
 * Class used to sort data types array
 * 
 * @author Kevin Green 2006
 * @since 2006-08-21 Kevin Green
 * @version 2006-08-21 Kevin Green
 */
public class DataTypeSorter implements Comparator{
	
	/**
	 * Default constructor
	 */
	public DataTypeSorter(){
		
	}
	
	/**
	 * Compairs objects and return negative, zero, positive based on
	 * if they are to be before, same, or after each other
	 * 
	 * @param objA The first object
	 * @param objB The second object
	 * @return -1, 0, 1 if they are to be before, same, or after each other
	 */
	public int compare(Object objA, Object objB){
		ArrayList order = EasikConstants.getDefaultDataTypesOrder();
		int indexA = order.indexOf(objA.toString());
		int indexB = order.indexOf(objB.toString());
		if(indexA == indexB)
			return 0;
		else if(indexA == -1)
			return 1;
		else if(indexB == -1)
			return 1;
		else if(indexA < indexB)
			return -1;
		else
			return 1;
	}
}
